#if NUNIT
using System;
using NUnit.Framework;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.VBECS.HL7Server.Core;
using gov.va.med.vbecs.UnitTests;

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.ListenerCore
{
	[TestFixture]
	public class ListenerCore_SimpleListenerHL7Manager : BaseTest
	{

		/// <summary>
		/// BCE COTS Interface
		/// </summary>
		private const string BCE_COTS_MESSAGE = 
			"MSH^~|\\&^WBC^500^VBECS^500^20110411084656^^BTS~O31^WBC201104110846564233^T^2.5^^^AL^AL^" + 
			CARRIAGE_RETURN +
			"PID^^^25448^^UXZLYX~SXYN~^^19151101^M^^^^^^^^^^^487024305^^^^^^^^^^^^^^^^^^^^" + 
			CARRIAGE_RETURN +
			"PV1^^O^CO-A/S DISPOSITION C~~~~~~~~~589^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^" +
			CARRIAGE_RETURN +
			"ORC^SC^22167000~OR^^^^^^^^^^53333~USER~ONE^^^^^^^^^^^^^" +
			CARRIAGE_RETURN +
			"BPO^1^~RED BLOOD CELLS^^" +
			CARRIAGE_RETURN +
			"BTX^1^8ba64936-e4c9-4d8f-b01d-710c00785cc4^^^^^^^500^^TX^F^20110411084652^~ONE~USER~^~USER~ONE~^20110411084542^20110411084652^~Yes^STOPPING, REACTION, Headache, Severe , Other interruption reason" + 
			CARRIAGE_RETURN +
			"NTE^^^MAIN COMMENT HERE^RE" + 
			CARRIAGE_RETURN +
			"NTE^^^Testing Purposes^VA-BCR" +
			CARRIAGE_RETURN;

		/// <summary>
		/// CPRS Interface
		/// </summary>
		private const string CPRS_MESSAGE = 
			"MSH|^~\\&|OERR|589|VBECS|589|20080526135401-0500||OMG^O19|5894312166|T|2.4|||AL|AL|USA" +
			CARRIAGE_RETURN +
			"PID|||5890045694V193464^^^^NI~493013508^^^^SS~14161^^^^PI||HALZ^ALUUN^J||19601126|M" +
			CARRIAGE_RETURN +
			"PV1||O|KC-1010 NEW PT CLINIC 2|||||||" + 
			CARRIAGE_RETURN +
			"ORC|NW|22179410^OR||22179406^OR|||||200805261354-0500|53342^USER^ONE||53342^USER^ONE||||^Transfuse|589^VA HEARTLAND - WEST, VISN 15|||" + 
			CARRIAGE_RETURN +
			"OBR|1|22179410^OR||1^TYPE \\T\\ SCREEN^99VBC^^|||||||O||89932;3080526;4;6478||^^SEND PATIENT||||||||||||^^^20080526^200805261354-0500^R^^" + 
			CARRIAGE_RETURN +
			"OBX|1||191^ALANINE AMINOTRANSFERASE^99LRT||17|IU/L|8-40||||F|||20020114093059-0500" +
			CARRIAGE_RETURN +
			"DG1|1||^^^^^|||A " +
			CARRIAGE_RETURN;

		/// <summary>
		/// Patient Merge Interface
		/// </summary>
		private const string PATIENT_MERGE_MESSAGE =
			"MSH^~|\\&^MPIF TRIGGER^^VBECS ADT^589^20110410173117-0500^^ADT~A40^5894298240^T^2.4^^^AL^AL^" +
			CARRIAGE_RETURN +
			"EVN^^^^^53342~USER~TEST~~~~~~USVHA&&0363~L~~~NI~VA FACILITY ID&589&L^^589" +
			CARRIAGE_RETURN +
			"PID^1^1000045036V498441~~~USVHA&&0363~NI~VA FACILITY ID&200M&L^1000045036V498441~~~USVHA&&0363~NI~VA FACILITY ID&200M&L|321000004~~~USSSA&&0363~SS~VA FACILITY ID&589&L|412583~~~USVHA&&0363~PI~VA FACILITY ID&589&L|321000003~~~USSSA&&0363~SS~VA FACILITY ID&589&L~~20110410|321000002~~~USSSA&&0363~SS~VA FACILITY ID&589&L~~20110410|5890045036V502660~~~USVHA&&0363~NI~VA FACILITY ID&589&L~~20061213|5890045035V840731~~~USVHA&&0363~NI~VA FACILITY ID&589&L~~20061213|1000045035V840731~~~USVHA&&0363~NI~VA FACILITY ID&200M&L~~20061213|5890045034V975882~~~USVHA&&0363~NI~VA FACILITY ID&589&L~~20061213|1000045034V103607~~~USVHA&&0363~NI~VA FACILITY ID&200M&L~~20110310^^MERGEN~PATIENT~~~~~L|MERGEM~PATIENT~~~~~A|MERGEL~PATIENT~~~~~A^DOFKDP~~~~~~M^19230101^F^^\"\"^22 WEST ST~\"\"~MUNDELEIN~IL~60060~USA~P~\"\"~097|~~CHICAGO~IL~~~N^097^(630)449-8332~PRN~PH|(630)456-8484~WPN~PH^(630)456-8484^^\"\"^0^^321000004^^^\"\"^CHICAGO IL^N^^^^^\"\"^^" +
			CARRIAGE_RETURN +
			"PD1^^^VA HEARTLAND - WEST, VISN 15~D~589" +
			CARRIAGE_RETURN +
			"MRG^1000045116V065714~~~USVHA&&0363~NI~VA FACILITY ID&589&L|412662~~~USVHA&&0363~PI~VA FACILITY ID&589&L^^^^^^MERGETHIRTY~THIRTY~~~~~L" +
			CARRIAGE_RETURN;

		/// <summary>
		/// Patient Update Interface
		/// </summary>
		private const string PATIENT_UPDATE_MESSAGE = 
			"MSH^~|\\&^VAFC PIMS^589^VBECS ADT^589^20110407120005-0500^^ADT~A08^5894298121^T^2.3^^^NE^NE^USA" +
			CARRIAGE_RETURN +
			"EVN^A08^20110407^^^USER,ONE" +
			CARRIAGE_RETURN +
			"PID^1^1000046604V343122^412730~4~M10^0701^USERALERTS~PATIENTONE^\"\"^19710101^F^^\"\"~~0005~\"\"~~CDC^\"\"~\"\"~\"\"~\"\"~\"\"~~P~\"\"~\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAE~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAA~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAC~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAM~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAO~\"\"~\"\"~~~\"\"&\"\"^^\"\"^\"\"^^\"\"^29^^666000701^^^\"\"~~0189~\"\"~~CDC^" +
			CARRIAGE_RETURN +
			"PD1^^^VA HEARTLAND - WEST, VISN 15~~589^\"\"" +
			CARRIAGE_RETURN +
			"PV1^1^O^\"\"^^^^^^^^^^^^^^^ACTIVE DUTY^^^^^^^^^^^^^^^^^^^^^^^^^^20110407^^^^^^1307988" +
			CARRIAGE_RETURN +
			"OBX^1" +
			CARRIAGE_RETURN +
			"ZPD^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^0^\"\"^\"\"^\"\"^\"\"^0^\"\"^0^\"\"^\"\"^\"\"" +
			CARRIAGE_RETURN +
			"ZSP^1^0^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^^\"\"" +
			CARRIAGE_RETURN +
			"ZEL^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^0^ACTIVE DUTY^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"" +
			CARRIAGE_RETURN +
			"ZCT^1^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"" +
			CARRIAGE_RETURN +
			"ZEM^1^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"" +
			CARRIAGE_RETURN +
			"ZFF^2^.351;" +
			CARRIAGE_RETURN +
			"ZIR^" +
			CARRIAGE_RETURN +
			"ZEN^1" +
			CARRIAGE_RETURN;

		/// <summary>
		/// 
		/// </summary>
		[Test]
		public void ProcessIncomingHL7Message_Pass_BCE_COTS()
		{
			HL7Interface bceCotsInterface = new HL7Interface( Common.InterfaceName.BCE_COTS.ToString() );
			//
			Assert.IsNotNull( bceCotsInterface, "bceCotsInterface IS NULL!" );
			// 
			Assert.IsNotNull( SimpleListenerHL7Manager.ProcessIncomingHL7Message( bceCotsInterface, BCE_COTS_MESSAGE ) );
		}

		/// <summary>
		/// 
		/// </summary>
		[Test]
		public void ProcessIncomingHL7Message_Pass_CPRS()
		{
			HL7Interface cprsInterface = new HL7Interface( Common.InterfaceName.CPRS.ToString() );
			//
			Assert.IsNotNull( cprsInterface, "cprsInterface IS NULL!" );
			// 
			Assert.IsNotNull(SimpleListenerHL7Manager.ProcessIncomingHL7Message( cprsInterface, CPRS_MESSAGE ) );
		}

		/// <summary>
		/// 
		/// </summary>
		[Test]
		public void ProcessIncomingHL7Message_Pass_Patient_Merge()
		{
			HL7Interface patientMergeInterface = new HL7Interface( Common.InterfaceName.Patient_Merge.ToString() );
			//
			Assert.IsNotNull( patientMergeInterface, "patientMergeInterface IS NULL!" );
			//
			Assert.IsNotNull( SimpleListenerHL7Manager.ProcessIncomingHL7Message( patientMergeInterface, PATIENT_MERGE_MESSAGE ) );
		}

		/// <summary>
		/// 
		/// </summary>
		[Test]
		public void ProcessIncomingHL7Message_Pass_Patient_Update()
		{
			HL7Interface patientUpdateInterface = new HL7Interface( Common.InterfaceName.Patient_Update.ToString() );
			//
			Assert.IsNotNull( patientUpdateInterface, "patientUpdateInterface IS NULL!" );
			//
			Assert.IsNotNull( SimpleListenerHL7Manager.ProcessIncomingHL7Message( patientUpdateInterface, PATIENT_UPDATE_MESSAGE ) );
		}

		/// <summary>
		/// ProcessIncomingHL7Messag - FAIL (Interface is NULL)
		/// </summary>
		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void ProcessIncomingHL7Message_Fail_Null_Interface()
		{
			SimpleListenerHL7Manager.ProcessIncomingHL7Message( null, CPRS_MESSAGE );
		}

		/// <summary>
		/// ProcessIncomingHL7Messag - FAIL (Message is NULL)
		/// </summary>
		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void ProcessIncomingHL7Message_Fail_Null_Message()
		{
			SimpleListenerHL7Manager.ProcessIncomingHL7Message( new HL7Interface( Common.InterfaceName.CPRS.ToString() ), null );
		}
	}
}
#endif